USE MASTER
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[sp_DropTableForeignKeys]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[sp_DropTableForeignKeys]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[sp_DropTableIndexes]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[sp_DropTableIndexes]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[sp_DropTablePrimaryKey]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[sp_DropTablePrimaryKey]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[sp_DropColumn]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[sp_DropColumn]
GO


SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE PROCEDURE sp_DropTableForeignKeys
(
	@TableName varchar(512),
	@FKType varchar(10) = 'C'
)
AS
/*
	Author: Roman Rehak
	Drops specified foreign keys on a table.
	Values for @FKType:
		'PARENT' or 'P' drops foreign keys pointing to parent tables
		'CHILD' or 'C' drops foreign keys from child tables
		'ALL' or 'A' drops both parent and child foreign keys
*/
SET NOCOUNT ON

DECLARE @TableID int
DECLARE @FKTableName varchar(512)
DECLARE @FKTableID int
DECLARE @FKName varchar(512)
DECLARE @FKID int
DECLARE @Message varchar(300)
DECLARE @SQL varchar(1000)
DECLARE @OwnerName varchar(512)

SET @TableID = OBJECT_ID(@TableName)
IF @TableID IS NULL
  RETURN 1

IF @FKType = 'CHILD' OR @FKType = 'C'
  BEGIN
	SELECT @Message = '***  Dropping Child Foreign Keys on "' + @TableName + '"  ***'
	DECLARE FKCur INSENSITIVE CURSOR FOR
    SELECT FKEYID, CONSTID
	FROM SYSREFERENCES, SYSCOLUMNS
	WHERE @TABLEID = RKEYID
	AND SYSCOLUMNS.ID = RKEYID
	AND COLID = RKEY1
  END
ELSE If @FKType = 'PARENT' OR @FKType = 'P'
  BEGIN
	SELECT @Message = '***  Dropping Parent Foreign Keys on "' + @TableName + '"  ***'

	DECLARE FKCur INSENSITIVE CURSOR FOR
	SELECT FKEYID, CONSTID
	FROM SYSREFERENCES, SYSCOLUMNS
	WHERE @TABLEID = FKEYID
	AND SYSCOLUMNS.ID = FKEYID
	AND COLID = FKEY1
  END
ELSE If @FKType = 'ALL' OR @FKType = 'A'
  BEGIN
	SELECT @Message = '***  Dropping All Foreign Keys on "' + @TableName + '"  ***'

	DECLARE FKCur INSENSITIVE CURSOR FOR
    SELECT FKEYID, CONSTID
	FROM SYSREFERENCES, SYSCOLUMNS
	WHERE @TABLEID = RKEYID
	AND SYSCOLUMNS.ID = RKEYID
	AND COLID = RKEY1
    UNION
	SELECT FKEYID, CONSTID
	FROM SYSREFERENCES, SYSCOLUMNS
	WHERE @TABLEID = FKEYID
	AND SYSCOLUMNS.ID = FKEYID
	AND COLID = FKEY1
  END
ELSE
  RETURN 1

OPEN FKCUR
FETCH NEXT FROM FKCUR INTO @FKTABLEID, @FKID
WHILE (@@FETCH_STATUS = 0)
  BEGIN
	SELECT @FKTABLENAME = OBJECT_NAME(@FKTableID)
	SELECT @FKNAME = OBJECT_NAME(@FKID)

	SELECT @OWNERNAME = NAME FROM SYSUSERS
	WHERE UID = (SELECT UID FROM SYSOBJECTS WHERE ID = @FKTableID)

	SELECT @SQL = 'ALTER TABLE [' + @OwnerName + '].[' + @FKTableName + '] DROP CONSTRAINT ['
		    + @FKName + ']'
	EXEC (@SQL)
	FETCH NEXT FROM FKCur INTO @FKTABLEID, @FKID
  END
CLOSE FKCur
DEALLOCATE FKCur

PRINT @Message
RETURN 0


GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE PROCEDURE sp_DropTableIndexes(
	@TABLE_NAME	VARCHAR(255)
)
AS
/*
	Author:	Roman Rehak
	Date:	5/14/2001
	Description : 	Drops indexes on a given table
*/
SET NOCOUNT ON
DECLARE @SQL	VARCHAR(2000),
	@INDEXNAME	VARCHAR(255),
	@INDEXSTATUS	INT,
	@OwnerName varchar(512),
	@TableID int

SET @TableID = OBJECT_ID(@Table_Name)
IF @TableID IS NULL
  RETURN 1

SELECT @OWNERNAME = NAME FROM SYSUSERS
WHERE UID = (SELECT UID FROM SYSOBJECTS WHERE ID = @TableID)

DECLARE INDEXCURSOR INSENSITIVE CURSOR FOR
	SELECT SYSINDEXES.NAME, SYSINDEXES.STATUS
	FROM SYSINDEXES INNER JOIN
	    SYSOBJECTS ON SYSINDEXES.ID = SYSOBJECTS.ID AND 
	    SYSINDEXES.NAME <> SYSOBJECTS.NAME
	WHERE (SYSINDEXES.ID = @TableID)
	AND (SYSINDEXES.STATUS & 2048) = 0
	AND LEFT(SYSINDEXES.NAME, 8) != '_WA_SYS_'
        AND SYSINDEXES.NAME <> ('T' + PARSENAME(@TABLE_NAME,1))
        AND SYSINDEXES.STATUS <> 2097248

OPEN INDEXCURSOR
FETCH NEXT FROM INDEXCURSOR INTO @INDEXNAME, @INDEXSTATUS
WHILE (@@FETCH_STATUS = 0)
    BEGIN
	  IF (@INDEXSTATUS & 4096) > 0    -- UNIQUE CONSTRAINT
	    BEGIN
		SELECT @SQL = 'ALTER TABLE [' + @OwnerName + '].[' + PARSENAME(@TABLE_NAME, 1) +
					'] DROP CONSTRAINT [' + @INDEXNAME + ']'
		EXEC (@SQL)
	    END
	  ELSE 		-- INDEX
	    BEGIN
		SELECT @SQL = 'DROP INDEX [' + @OwnerName + '].[' +
				PARSENAME(@TABLE_NAME, 1) + '].[' + @INDEXNAME + ']'
		EXEC (@SQL)
	    END
	
	FETCH NEXT FROM INDEXCURSOR INTO @INDEXNAME, @INDEXSTATUS
    END

CLOSE INDEXCURSOR
DEALLOCATE INDEXCURSOR

PRINT '*** Indexes dropped on "' + @table_name + '" ***'






GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE PROCEDURE sp_DropTablePrimaryKey(
	@TableName varchar(500)
)
AS
/*
	Author:	Roman Rehak
	Date:	5/14/2001
	Description : 	Drops the primary key on a given table
*/
SET NOCOUNT ON
DECLARE @SQL varchar(4000)
DECLARE @PrimaryKeyName varchar(500)
DECLARE @OwnerName varchar(512)
DECLARE @TableID int

SET @TableID = OBJECT_ID(@TableName)
IF @TableID IS NULL
  RETURN 1

SELECT @OWNERNAME = NAME FROM SYSUSERS
WHERE UID = (SELECT UID FROM SYSOBJECTS WHERE ID = @TableID)

SELECT @PrimaryKeyName = sysindexes.name
FROM sysindexes INNER JOIN
sysobjects ON sysindexes.id = sysobjects.id AND 
sysindexes.name <> sysobjects.name
WHERE (sysobjects.ID = @TableID)
AND (sysindexes.status & 2048) <> 0

IF @PrimaryKeyName IS NOT NULL
  BEGIN
	  -- Drop child foreign keys first
    SELECT @SQL = 'EXEC sp_DropTableForeignKeys ''[' + @OwnerName +
			'].[' +  PARSENAME(@TableName, 1) + ']'', ''Child'''
    EXEC (@SQL)
	SELECT @SQL = 'ALTER TABLE [' + @OwnerName + '].[' + 
		PARSENAME(@TableName, 1) + '] DROP CONSTRAINT [' + @PrimaryKeyName + ']'
	EXEC (@SQL)

    PRINT '*** Primary Key dropped on "' + @TableName + '" ***'
  End


GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO


SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE PROCEDURE sp_DropColumn
(
	@TableName sysname,
	@ColumnName sysname
)
AS
/*
	Author: Roman Rehak
	sp_DropColumn drops a column in a table,
	after deleting the column default and any column constraints
*/
DECLARE @DefaultID int
DECLARE @DefaultName sysname
DECLARE @ColumnID smallint
DECLARE @ConstraintID int
DECLARE @TableID int
DECLARE @SQL varchar(4000)
DECLARE	@OwnerName varchar(512)

SET @TableID = OBJECT_ID(@TableName)
IF @TableID IS NULL
  BEGIN
    PRINT '*** Table "' + @TableName + '" does not exist ***'
    RETURN 1
  END

SELECT @OWNERNAME = NAME FROM SYSUSERS
WHERE UID = (SELECT UID FROM SYSOBJECTS WHERE ID = @TableID)

SELECT @DefaultID = cdefault from syscolumns
WHERE NAME = PARSENAME(@ColumnName, 1)
AND ID = OBJECT_ID(@TableName)

IF @DefaultID IS NULL
  BEGIN
    PRINT '*** Column ' + @ColumnName + ' does not exist ***'
    RETURN 1
  END

IF @DefaultID <> 0
  BEGIN
	-- default exists, let's drop it
    SELECT @DefaultName = NAME FROM SYSOBJECTS
	WHERE ID = @DefaultID

	SET @SQL = 'ALTER TABLE [' + @OwnerName + '].[' + PARSENAME(@TABLENAME, 1) +
		'] DROP CONSTRAINT [' + @DefaultName + ']'
	EXEC(@SQL)
  END

  SELECT @ColumnID = ColID FROM syscolumns
  WHERE name = @ColumnName and id = OBJECT_ID(@TableName)

-- Drop constraints
WHILE (0=0)
BEGIN

  SELECT @ConstraintID = constid FROM dbo.sysconstraints
  WHERE id = OBJECT_ID(@TableName) AND colid = @ColumnID

  IF @ConstraintID IS NOT NULL
  BEGIN
	SET @SQL = 'ALTER TABLE [' + @OwnerName + '].[' + PARSENAME(@TABLENAME, 1) +
		' DROP CONSTRAINT [' + OBJECT_NAME(@ConstraintID) + ']'
	EXEC(@SQL)
	SET @ConstraintID = NULL
  END
  ELSE
    BREAK
END

SET @SQL = 'ALTER TABLE ' + @TableName +
	'  DROP COLUMN ' + @ColumnName 
EXEC(@SQL)

PRINT '*** Column "' + @ColumnName + '" has been dropped. ***'
RETURN 0
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

exec sp_MS_MarkSystemObject 'sp_DropColumn'
GO
